using System;

class Program
{
    static void Main()
    {
        string line1 = Console.ReadLine() + " ";
        string numberOfPeopleS = line1.Substring(0, line1.IndexOf(' '));
        int numberOfPeople = Convert.ToInt32(numberOfPeopleS);
        line1 = line1.Remove(0, numberOfPeopleS.Length + 1);
        string numberOfOvertakesS = line1.Substring(0, line1.IndexOf(' '));
        int numberOfOvertakes = Convert.ToInt32(numberOfOvertakesS);
        line1 = line1.Remove(0, numberOfOvertakesS.Length + 1);
        int[,] data = new int[numberOfPeople, 2];
        for (int i = 0; i < numberOfPeople; i++)
        {
            string newLine = Console.ReadLine() + " ";
            for (int j = 0; j < 2; j++)
            {
                string newLineSub = newLine.Substring(0, newLine.IndexOf(' '));
                data[i, j] = Convert.ToInt32(newLineSub);
                newLine = newLine.Remove(0, newLineSub.Length + 1);
            }
        }
        int[] positions = new int[numberOfPeople];
        int[] velocities = new int[numberOfPeople];
        for (int i = 0;i < numberOfPeople;i++)
        {
            positions[i] = data[i,0];
            velocities[i] = data[i, 1];
        }
        double timeElapsed = CalculateTime(numberOfPeople, numberOfOvertakes, positions, velocities);
        Console.WriteLine(timeElapsed);
    }

    static double CalculateTime(int numberOfPeople, int numberOfOvertakes, int[] positions, int[] velocities)
    {
        double timeElapsed = 0;
        int overtakesCount = 0;

        while (overtakesCount < numberOfOvertakes)
        {
            double minTime = double.MaxValue;

            for (int i = 0; i < numberOfPeople - 1; i++)
            {
                if (positions[i] < positions[i + 1] && velocities[i] > velocities[i + 1])
                {
                    double timeToOvertake = (double)(positions[i + 1] - positions[i]) / (velocities[i] - velocities[i + 1]);

                    if (timeToOvertake < minTime)
                    {
                        minTime = timeToOvertake;
                    }
                }
            }

            if (minTime == double.MaxValue)
            {
                break;
            }

            for (int i = 0; i < numberOfPeople; i++)
            {
                positions[i] += (int)(velocities[i] * minTime);
            }

            timeElapsed += minTime;
            overtakesCount++;
        }

        return timeElapsed;
    }
}